#include "relacionaritensconsumo.h"
#include "ui_relacionaritensconsumo.h"

RelacionarItensConsumo::RelacionarItensConsumo(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::RelacionarItensConsumo)
{
    ui->setupUi(this);
    setWindowFlags(0);

    categoria=new QSqlQueryModel();
    QueryUtility::LerCategoria(categoria);
    ui->comboBox_cat_produto->addItem("Tipo", "");
    for(int i=0;i<categoria->rowCount();i++){
        ui->comboBox_cat_produto->addItem(categoria->record(i).value(0).toString(), categoria->record(i).value(0).toString());
    }

    connect(&spooler, &QTimer::timeout, this, &RelacionarItensConsumo::SearchItem);
    spooler.start(100);

    connect(&spooleringred, &QTimer::timeout, this, &RelacionarItensConsumo::SearchIngrediente);
    spooleringred.start(100);

    ui->tabWidget->setCurrentIndex(0);

}

RelacionarItensConsumo::~RelacionarItensConsumo()
{
    delete ui;
}

void RelacionarItensConsumo::SetValues(Login *conexao){
    conn=conexao;
    produtos=new QSqlQueryModel();
    sortProdutos=new QSortFilterProxyModel();

    //itens=new QSqlQueryModel();
    //sortItens=new QSortFilterProxyModel();

    QueryUtility::LerProdutos(conn, produtos, "", "", "");
    produtos->setHeaderData(PRODUTO_PRECOID, Qt::Horizontal, tr("ID"));
    produtos->setHeaderData(PRODUTO_ITEMNOME, Qt::Horizontal, tr("Item"));
    produtos->setHeaderData(PRODUTO_TIPO, Qt::Horizontal, tr("Categoria"));
    produtos->setHeaderData(PRODUTO_TAMANHO, Qt::Horizontal, tr("Tamanho"));
    produtos->setHeaderData(PRODUTO_PRECO, Qt::Horizontal, tr("Preço\nVenda"));

    sortProdutos->setDynamicSortFilter(true);
    sortProdutos->setSourceModel(produtos);
    ui->tableView_produtos->setModel(sortProdutos);
    ui->tableView_produtos->setSortingEnabled(true);

    ui->tableView_produtos->setColumnHidden(PRODUTO_IDPRECO,true);
    ui->tableView_produtos->setColumnHidden(PRODUTO_IDITEM,true);
    ui->tableView_produtos->setItemDelegateForColumn(PRODUTO_PRECO,new NumberFormatDelegate(this));

    sortItens=new QSortFilterProxyModel();
    sortItens->setDynamicSortFilter(true);
    sortItens->setSourceModel(produtos);
    ui->tableView_itens->setModel(sortItens);
    ui->tableView_itens->setSortingEnabled(true);
   // ui->tableView_itens->setModel(produtos);
    ui->tableView_itens->setColumnHidden(PRODUTO_IDPRECO,true);
    ui->tableView_itens->setColumnHidden(PRODUTO_IDITEM,true);
    ui->tableView_itens->setItemDelegateForColumn(PRODUTO_PRECO,new NumberFormatDelegate(this));

    ui->tableView_itens->setWordWrap(true);

    ingredientes=new QSqlQueryModel();
    sortIngredientes=new QSortFilterProxyModel();

    listaingredientes=new QSqlQueryModel();
    sortListaIngredientes=new QSortFilterProxyModel();
    QueryUtility::Ingredientes(conn, listaingredientes);

    listaingredientes->setHeaderData(3, Qt::Horizontal, tr("Ingrediente"));
    listaingredientes->setHeaderData(4, Qt::Horizontal, tr("Quant/prod"));
    listaingredientes->setHeaderData(5, Qt::Horizontal, tr("Embalagem"));
    listaingredientes->setHeaderData(6, Qt::Horizontal, tr("Unid."));

    sortListaIngredientes->setDynamicSortFilter(true);
    sortListaIngredientes->setSourceModel(listaingredientes);
    ui->tableView_ingredientes->setModel(sortListaIngredientes);
    ui->tableView_ingredientes->setSortingEnabled(true);

    ui->tableView_ingredientes->setColumnHidden(0,true);
    ui->tableView_ingredientes->setColumnHidden(1,true);
    ui->tableView_ingredientes->setColumnHidden(2,true);

}

void RelacionarItensConsumo::AtualizarTelaItens(){
    QueryUtility::LerItensConsumiveis(conn, ingredientes);   
    AtualizarTabelaIngredientes(ui->tableView_ingredientes_2);
}

void RelacionarItensConsumo::AtualizarTabelaIngredientes(QTableView *table){
    QStandardItemModel *model;
    float valor, custo;

    ingredientes->setHeaderData(4, Qt::Horizontal, tr("Ingrediente"));
    ingredientes->setHeaderData(5, Qt::Horizontal, tr("Quant/prod"));
    ingredientes->setHeaderData(6, Qt::Horizontal, tr("Embalagem"));
    ingredientes->setHeaderData(7, Qt::Horizontal, tr("Unidade"));
    ingredientes->setHeaderData(8, Qt::Horizontal, tr("Custo/porção"));

    model = new QStandardItemModel(ingredientes->rowCount(),5,this);

    QModelIndex index;

    sortIngredientes->setDynamicSortFilter(true);
    sortIngredientes->setSourceModel(ingredientes);
    table->setModel(sortIngredientes);
    table->setSortingEnabled(true);

    //table->setModel(model);
    model->setHorizontalHeaderItem(0, new QStandardItem("Ingrediente"));
    model->setHorizontalHeaderItem(1, new QStandardItem("Quant/prod"));
    model->setHorizontalHeaderItem(2, new QStandardItem("Embalagem"));
    model->setHorizontalHeaderItem(3, new QStandardItem("Unidade"));
    model->setHorizontalHeaderItem(4, new QStandardItem("Custo/porção"));

    custo=0;
    for(int i=0;i<ingredientes->rowCount();i++){
        index= model->index(i,0,QModelIndex());
        model->setData(index,ingredientes->record(i).value(4).toString());
        index= model->index(i,1,QModelIndex());
        model->setData(index,ingredientes->record(i).value(5).toString());
        index= model->index(i,2,QModelIndex());
        model->setData(index,ingredientes->record(i).value(6).toString());
        index= model->index(i,3,QModelIndex());
        model->setData(index,ingredientes->record(i).value(7).toString());
        index= model->index(i,4,QModelIndex());
        valor=ingredientes->record(i).value(5).toFloat()*ingredientes->record(i).value(8).toFloat()/ingredientes->record(i).value(6).toFloat();
        custo+=valor;
        model->setData(index,QString::number(valor, 'f',2));
    }

    ui->lcdNumber_custo->display(custo);
    ui->lcdNumber_venda->display(precoitem);
    if(custo)
        ui->lcdNumber_lucro->display((precoitem/custo-1)*100);
    else
        ui->lcdNumber_lucro->display(0);
}

void RelacionarItensConsumo::on_pushButton_relacionar_clicked()
{
    if(!produtos->rowCount() || !listaingredientes->rowCount()){
        return;
    }

    if(!id_quantingr){
        QMessageBox::information(this,tr("Ingrediente"),tr("Quantidade utilizada não encontrada!"));
        return;
    }

    //qDebug() << "RelacionarItensConsumo";
    Utility::TableColumn(ui->tableView_produtos);
    Utility::TableColumn(ui->tableView_ingredientes);

    QModelIndexList index_produtos=ui->tableView_produtos->selectionModel()->selectedIndexes();
    QModelIndexList index_ingredientes=ui->tableView_ingredientes->selectionModel()->selectedIndexes();

    GravarRelIngredientes(&index_produtos, produtos, sortProdutos,  &index_ingredientes, listaingredientes, ingredientes, sortIngredientes);

    on_tableView_itens_clicked(ui->tableView_itens->selectionModel()->currentIndex());


}

void RelacionarItensConsumo::on_pushButton_ok_clicked()
{
    bool flag;
    float qtde=Utility::FloatNumber(ui->lineEdit_qtde->text()).toFloat(&flag);

    if(flag){
        if(GravaQuantidadeConsumivel(id_quantingr, qtde,id_consumivel)){
            QueryUtility::Ingredientes(conn, listaingredientes, ui->lineEdit_ingredientesfiltro->text());
            ui->tableView_ingredientes->setModel(listaingredientes);

            QueryUtility::LerIDIngredientes(conn,id_ingrediente, ingredientes );
            AtualizarTabelaIngredientes(ui->tableView_ingredientes_2);

            LimparInput();
        }
    }
    else{
        QMessageBox::information(this,tr("Ingrediente"),tr("Erro para alterar ingrediente!"));
    }
}

void RelacionarItensConsumo::LimparInput(){
    ui->label_ingrediente->setText("[ingrediente]");
    ui->lineEdit_qtde->setText("");
    ui->label_unidade->setText("[unidade]");
    id_quantingr =-1;
    id_consumivel=-1;
    id_relconsumivel=0;
}

void RelacionarItensConsumo::on_tableView_itens_clicked(const QModelIndex &index)
{
    int linha=sortProdutos->mapToSource(index).row();
    id_ingrediente=produtos->record(linha).value(PRODUTO_IDPRECO).toInt();
    precoitem=produtos->record(linha).value(PRODUTO_PRECO).toFloat();

    id_quantingr=0;
    ui->label_ingrediente_2->setText("[ingrediente]");

    QueryUtility::LerIDIngredientes(conn,id_ingrediente, ingredientes );
    AtualizarTabelaIngredientes(ui->tableView_ingredientes_2);

}

void RelacionarItensConsumo::on_tableView_ingredientes_2_clicked(const QModelIndex &index)
{
    id_quantingr=ingredientes->record(index.row()).value(3).toInt();
    id_relconsumivel=ingredientes->record(index.row()).value(0).toInt();
    ui->label_ingrediente_2->setText(ingredientes->record(index.row()).value(4).toString());
}

void RelacionarItensConsumo::on_tableView_ingredientes_clicked(const QModelIndex &index)
{
    if(!listaingredientes->rowCount())
        return;

    int linha=sortListaIngredientes->mapToSource(index).row();

    ui->label_ingrediente->setText(listaingredientes->record(linha).value(INGREDIENTES_ITEMNOME).toString());
    ui->lineEdit_qtde->setText(listaingredientes->record(linha).value(INGREDIENTES_QUANTNEC).toString());
    ui->label_unidade->setText(listaingredientes->record(linha).value(INGREDIENTES_UNIDADE).toString());
  //  ui->lineEdit_embalagem->setText(ingredientes->record(index.row()).value(INGR_EMBALAGEM).toString());

    id_quantingr=listaingredientes->record(linha).value(INGREDIENTES_IDQUANTINGRE).toInt();
    id_consumivel=listaingredientes->record(linha).value(INGREDIENTES_IDCONSUMIVEL).toInt();

}

void RelacionarItensConsumo::on_pushButton_duplicar_clicked()
{
    if(!listaingredientes->rowCount())
        return;

    if(!id_quantingr){
        QMessageBox::information(this,tr("Ingrediente"),tr("Quantidade utilizada não encontrada!"));
        return;
    }

    if(InserirNovaQuant(id_consumivel)){
        QueryUtility::Ingredientes(conn, listaingredientes, ui->lineEdit_ingredientesfiltro->text());
        ui->tableView_ingredientes->setModel(listaingredientes);
        LimparInput();
    }

}

void RelacionarItensConsumo::on_comboBox_cat_produto_activated(const QString &arg1)
{
    QString filtro=ui->lineEdit_produtofiltro->text();
    QueryUtility::LerProdutos(conn, produtos, filtro, ui->comboBox_cat_produto->currentData().toString(), "");
}


void RelacionarItensConsumo::on_pushButton_apagar_clicked()
{
    if(!listaingredientes->rowCount())
        return;

    if(!Utility::confirm_btn("Apagar item", "Confirma apagar item?"))
        return;

    if(QueryUtility::DeleteIdTable(id_quantingr, "quant_ingrediente", "id_quantingr" )){
        QueryUtility::Ingredientes(conn, listaingredientes, ui->lineEdit_ingredientesfiltro->text());
        ui->tableView_ingredientes->setModel(listaingredientes);
        LimparInput();
    }

}

void RelacionarItensConsumo::on_pushButton_apagaringrediente_clicked()
{
    if(!ingredientes->rowCount())
        return;

    if(!Utility::confirm_btn("Apagar item", "Confirma apagar item?"))
        return;

    if(QueryUtility::DeleteIdTable(id_relconsumivel, "relacaoconsumiveis", "id_relconsumiveis" )){
        QueryUtility::LerIDIngredientes(conn,id_ingrediente, ingredientes );
        AtualizarTabelaIngredientes(ui->tableView_ingredientes_2);

    }
}

void RelacionarItensConsumo::on_tableView_produtos_clicked(const QModelIndex &index)
{
    ui->tableView_itens->selectRow(sortItens->mapToSource(index).row());
    on_tableView_itens_clicked(ui->tableView_itens->selectionModel()->currentIndex());
}

void RelacionarItensConsumo::SearchItem(){

    if(ui->lineEdit_produtofiltro->text()!=filtraritem){
        filtraritem=ui->lineEdit_produtofiltro->text();
        ntasks=0;

        return;
    }
    else{
        ntasks++;
        if(ntasks<5 || filtraritem==filtraritem_old){
            return;
        }
    }

    filtraritem_old=filtraritem;

    QueryUtility::LerProdutos(conn, produtos, filtraritem, ui->comboBox_cat_produto->currentData().toString(), "");

}

void RelacionarItensConsumo::SearchIngrediente(){
    if( ui->lineEdit_ingredientesfiltro->text()!=filtraringred){
        filtraringred=ui->lineEdit_ingredientesfiltro->text();
        ntasksingred=0;

        return;
    }
    else{
        ntasksingred++;
        if(ntasksingred<5 || filtraringred==filtraringred_old ){
            return;
        }
    }

    filtraringred_old=filtraringred;

    QueryUtility::Ingredientes(conn, listaingredientes,filtraringred);

}
