#ifndef RELACIONARITENSCONSUMO_H
#define RELACIONARITENSCONSUMO_H

#include <QDialog>

#include "constants.h"
#include "utility.h"
#include "queryutility.h"
#include "custoporcaodelegate.h"

namespace Ui {
class RelacionarItensConsumo;
}

class RelacionarItensConsumo : public QDialog
{
    Q_OBJECT

public:
    explicit RelacionarItensConsumo(QWidget *parent = 0);
    ~RelacionarItensConsumo();
    void SetValues(Login *conexao);
    void SearchItem();
    void SearchIngrediente();
    void LimparInput();

private slots:

    bool GravaQuantidadeConsumivel(int id, float qtde, int idcons){
        QSqlQuery query;

        if(id){
            query.prepare("update quant_ingrediente set quant=:qtde where id_quantingr=:id");
            query.bindValue(":id", id);
        }
        else{
            query.prepare("insert into quant_ingrediente set quant=:qtde, id_consumivel=:idcons");
            query.bindValue(":idcons", idcons);
        }
        query.bindValue(":qtde", qtde);
        if(query.exec())
            return true;
        else{
            qDebug() << query.lastError().text() << id <<qtde << idcons  ;
            return false;
        }


    }


    bool VerificaIngrediente(int idpreco, int idingrediente, QSqlQueryModel *relacao ){

        bool flag=true;
        for(int i=0;i<relacao->rowCount();i++){

            qDebug() << idpreco << idingrediente;
            qDebug() << relacao->record(i).value(9).toInt() << relacao->record(i).value(3).toInt();

            if(relacao->record(i).value(9).toInt()==idpreco &&
               relacao->record(i).value(3).toInt()==idingrediente ){
                flag=false;
                break;
            }
        }

        return flag;

    }

    bool GravarRelIngredientes(QModelIndexList *list_produtos, QSqlQueryModel *produtos, QSortFilterProxyModel *sortProdutos,
                               QModelIndexList *list_ingredientes,  QSqlQueryModel *ingredientes,
                               QSqlQueryModel *relacao, QSortFilterProxyModel *sortIngredientes ){
        QVariantList id_preco, id_consumivel;
        int linha_produto, linha_ingrediente;
        int idpreco, idingrediente;

        foreach (QModelIndex item_produto, *list_produtos) {
            //linha_produto=item_produto.row();
            linha_produto=sortProdutos->mapToSource(item_produto).row();

            idpreco=produtos->record(linha_produto).value(PRODUTO_IDPRECO).toInt();
            foreach (QModelIndex item_ingrediente, *list_ingredientes) {
                //linha_ingrediente=item_ingrediente.row();
                linha_ingrediente=sortIngredientes->mapToSource(item_ingrediente).row();
                idingrediente=ingredientes->record(linha_ingrediente).value(INGREDIENTES_IDQUANTINGRE).toInt();

                if(VerificaIngrediente(idpreco, idingrediente, relacao) && idpreco && idingrediente){
                    id_preco << idpreco;
                    id_consumivel << idingrediente;
                 }
            }
        }
        QSqlQuery query;
        query.prepare("insert into relacaoconsumiveis (id_preco, id_quantingr)"
                      "values (:id_preco, :id_consumivel) ");

        query.bindValue(":id_preco", id_preco);
        query.bindValue(":id_consumivel", id_consumivel);
        if(query.execBatch())
            return true;
        else{
            qDebug() << "GravarRelIngredientes" << query.lastError().text();
            return false;
        }
    }

    bool InserirNovaQuant(int id){
        QSqlQuery query;
        query.prepare("insert into quant_ingrediente (id_consumivel, quant)"
                      "values (:id, 0) ");
        query.bindValue(":id", id);
        return query.exec();
    }

    void AtualizarTelaItens();

    void on_pushButton_relacionar_clicked();

    void on_pushButton_ok_clicked();

    void on_tableView_itens_clicked(const QModelIndex &index);

    void on_tableView_ingredientes_2_clicked(const QModelIndex &index);

    void AtualizarTabelaIngredientes(QTableView *table);

    void on_tableView_ingredientes_clicked(const QModelIndex &index);

    void on_pushButton_duplicar_clicked();

    void on_comboBox_cat_produto_activated(const QString &arg1);

    void on_pushButton_apagar_clicked();

    void on_pushButton_apagaringrediente_clicked();

    void on_tableView_produtos_clicked(const QModelIndex &index);

private:
    Ui::RelacionarItensConsumo *ui;
    Login *conn;
    QSqlQueryModel /**itens,*/ *produtos, *ingredientes, *listaingredientes, *categoria;
    QSortFilterProxyModel *sortProdutos, *sortIngredientes, *sortItens, *sortListaIngredientes;
    int id_quantingr=-1, id_consumivel=-1, id_ingrediente=-1, id_relconsumivel=0;
    float precoitem=0;
    QTimer          spooler, spooleringred;
    int ntasks=0, ntasksingred=0;
    QString filtraritem="", filtraritem_old="";
    QString filtraringred="", filtraringred_old="";

};

#endif // RELACIONARITENSCONSUMO_H
