@echo off
REM Alterar "Ethernet" pelo nome da sua interface de rede
set interfaceName="Ethernet"

REM Defina o IP desejado, a máscara de sub-rede, o gateway padrão e os servidores DNS
set ipAddress=192.168.1.200
set subnetMask=255.255.255.0
set gateway=192.168.1.1
set dns1=8.8.8.8
set dns2=8.8.4.4

REM Configurar o endereço IP estático
netsh interface ipv4 set address name=%interfaceName% static %ipAddress% %subnetMask% %gateway%

REM Configurar os servidores DNS
netsh interface ipv4 set dnsservers name=%interfaceName% static %dns1% primary
netsh interface ipv4 add dnsservers name=%interfaceName% %dns2% index=2

echo Configuração de IP alterada com sucesso.
pause