#!/bin/bash

#***********************************************************************#
# Rastering script for Bematech linux CUPS printer drivers.             #
# PLEASE DO NOT EDIT THIS FILE.                                         #
#                                                                       #
# Company: Bematech S/A.                                                #
#***********************************************************************#

JOB_ID=$1
PRINT_USER=$2
TITLE=$3
COPIES=$4
OPTIONS=$5
PRINT_FILE=$6

# Create a grayscale bmp file for each page
if [ -z "$PRINT_FILE"]
then
    gs -sDEVICE=bmpgray -r203.1 -sOutputFile=/tmp/bemafilter-"$JOB_ID"-%03d.bmp -q -
else
    gs -sDEVICE=bmpgray -r203.1 -sOutputFile=/tmp/bemafilter-"$JOB_ID"-%03d.bmp -q "$PRINT_FILE"
fi


declare -a files
files=(/tmp/bemafilter-"$JOB_ID"-*)
pos=$(( ${#files[*]} - 1 ))
last=${files[$pos]}

# for each generated page...
for entry in "${files[@]}"
do
    if [[ $entry == $last ]]
    then
	OPTIONS="$OPTIONS Last=true"
    fi

    # Run the filter pipeline with thresholding to avoid unwanted dithering
    cat "$entry" | \
    /usr/lib/cups/filter/bemabmpthreshold "$JOB_ID" "$PRINT_USER" "$TITLE" "$COPIES" "$OPTIONS" | \
    /usr/lib/cups/filter/imagetoraster "$JOB_ID" "$PRINT_USER" "$TITLE" "$COPIES" "$OPTIONS" | \
    /usr/lib/cups/filter/rastertobema "$JOB_ID" "$PRINT_USER" "$TITLE" "$COPIES" "$OPTIONS"
done

# remove generated bmp files
rm /tmp/bemafilter-"$JOB_ID"-*.bmp
